import requests, zipfile, io, os, shutil, subprocess
from packaging import version

LOCAL_VERSION = "1.0"
VERSION_URL = "https://raw.githubusercontent.com/TON_PSEUDO/TON_DEPOT/main/version.txt"
ZIP_URL = "https://github.com/TON_PSEUDO/TON_DEPOT/releases/download/v1.0/1.0_flat.zip"
APP_FILE = "app.py"

EXCLUDED_FILES = {".env", "cert.pem", "key.pem"}
EXCLUDED_DIRS = {"venv"}

def should_exclude(rel_path):
    parts = rel_path.split(os.sep)
    return parts[0] in EXCLUDED_DIRS or rel_path in EXCLUDED_FILES

def download_and_replace():
    r = requests.get(ZIP_URL, timeout=10)
    with zipfile.ZipFile(io.BytesIO(r.content)) as zip_ref:
        zip_ref.extractall("temp_update")

    for root, dirs, files in os.walk("temp_update"):
        for file in files:
            src = os.path.join(root, file)
            rel = os.path.relpath(src, "temp_update")
            if should_exclude(rel):
                print(f"[INFO] Exclu : {rel}")
                continue
            dst = os.path.join(".", rel)
            os.makedirs(os.path.dirname(dst), exist_ok=True)
            shutil.move(src, dst)

    shutil.rmtree("temp_update")
    with open("version.txt", "w") as f:
        f.write(get_remote_version())
    subprocess.Popen(["python", APP_FILE])
    os._exit(0)

def get_remote_version():
    r = requests.get(VERSION_URL, timeout=5)
    return r.text.strip()

def check_and_update():
    try:
        remote = version.parse(get_remote_version())
        local = version.parse(LOCAL_VERSION)
        if remote > local:
            print("[INFO] Mise à jour disponible.")
            download_and_replace()
        else:
            print("[INFO] Application à jour.")
    except Exception as e:
        print(f"[ERREUR] {e}")

if __name__ == "__main__":
    check_and_update()
